HISTORIA_FINAL:
;--------------------------------------
; WYZ
	ld	a,$08
	call	@@START_FADE_OUT	; parar la musica de menos a mas
; WYZ
;--------------------------------------

	ld	a,2			; mientras estamos en este menu no animaremos objetos
	ld	[EN_HISTORIA],a		; almacenamos 2 en la variable EN_HISTORIA para evitar la pulsacion

; borrar todos los sprites en SPRTBL y ATRTBL
	call	CLRSPR			; 069h - BIOS - Clear all sprites

	call	MARCADOR		; mostramos el marcador actualizado

; vamos a borrar la pantalla omitiendo los marcadores
	ld	hl,NAMTBL+(2*32)	; inicio en la linea 3 de la NAMTBL
	ld	bc,22*32		; tamao 22 lineas x 32 CHR
	xor	a			; rellenar con 0
	call	FILVRM			; 056h - BIOS  Fill block of VRAM with data byte

; LOCATE 11,15: PRINT "TU PUNTUACION"
	ld	hl,TXT_SCORE		; direccin donde tenemos  el texto
IF (IDIOMA==1)
	ld	de,NAMTBL+(11*32)+8	; LOCATE 11,8 en la NAMBTL en VRAM
	ld	bc,13			; Numero de CHR que tiene el texto
ELSE
	ld	de,NAMTBL+(11*32)+11	; LOCATE 11,11 en la NAMBTL en VRAM
	ld	bc,10			; Numero de CHR que tiene el texto
ENDIF
	call	LDIRVM			; 056h - BIOS  Copy block to VRAM, from memory

; bucle para una pausa
	ld	b,255			; valor de repeticion
pausa0:
	halt				; esperar a la interrupcion
	djnz	pausa0			; repetir mientras B no sea 0

	call	GFXmenus		; Colocar los graficos logos y letras de los menus

; Esto lo realizamos para que no se vea nada en la pantalla
; Mientras colocamos los CHR y los Colores en la VRAM 
	call	DISSCR			; 041h - BIOS - Disable screen

	call	GFXmenus		; Colocar los graficos logos y letras de los menus

; Descomprimir los grficos para el final del juego
	ld	hl,CHRs_FINAL0		; origen
	ld	de,bufferCHR		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Descomprimir la pantalla 0 para el final del juego
	ld	hl,NAM_FINAL0		; origen
	ld	de,bufferNAM		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Descomprimir todos los textos del final del juego de ROM a RAM
	ld	hl,TXTs_FINAL		; origen
	ld	de,TXT_FINAL0		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Colocar el buffer de CHRs de RAM en VRAM
; BANCO 0
	ld	de,CHRTBL		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM

; Colocar el bufferNAM en VRAM
	call	bufNAMaVRAM		; Mini-Rutina que lleva bufferNAM a VRAM 24 lineas

; colocar el color para los CHRs del BANCO 0 en GRIS
	ld	hl,CLRTBL		; CLRTBL en VRAM
	ld	bc,256*8		; n de bytes a rellenar 256 CHRs * 8 bytes
	ld	a,$E0			; a=E0 - Valor a rellenar color gris fondo negro
	call	FILVRM			; 056h - BIOS  Fill block of VRAM with data byte 

; Esto lo realizamos para que se muestre de nuevo la pantalla.
	call    ENASCR			; 044h - BIOS - Enable screen

;--------------------------------------
; WYZ
	CALL	PLAYER_OFF	; para la musica
; descomprimir la musica de la historia del juego en RAM
	ld	hl,SONG_4	; origen
	ld	de,MUSICA	; destino
	call	unpack		; rutina descompresora pletter de rom a ram
; hacer sonar la cancion de la historia final del juego
	XOR	A		; * CANCION N 0
	CALL	CARGA_CANCION	; Hacer sonar la cancion.
; WYZ
;--------------------------------------

; texto de la animacion 0
	ld	de,TXT_FINAL0		; direccion del texto a imprimir
	ld	hl,NAMTBL+(9*32)	; LOCATE 9,0 en la NAMBTL en VRAM
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR

; bucle para una pausa
	ld	b,150
pausa1:
	halt
	djnz	pausa1

; Descomprimir la pantalla 1 para el final del juego
	ld	hl,NAM_FINAL1		; origen
	ld	de,bufferNAM		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Colocar el bufferNAM en VRAM
	call	bufNAMaVRAM		; Mini-Rutina que lleva bufferNAM a VRAM 24 lineas

; texto de la animacion 1
	ld	de,TXT_FINAL1		; direccion del texto a imprimir
	ld	hl,NAMTBL+(9*32)	; LOCATE 9,0 en la NAMBTL en VRAM
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR

; bucle para una pausa
	ld	b,150
pausa2:
	halt
	djnz	pausa2

; Colocar el bufferNAM en VRAM
	call	bufNAMaVRAM		; Mini-Rutina que lleva bufferNAM a VRAM 24 lineas

; texto de la animacion 2
	ld	de,TXT_FINAL2		; direccion del texto a imprimir
	ld	hl,NAMTBL+(9*32)	; LOCATE 9,0 en la NAMBTL en VRAM
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR

; Bucle de retardo y salimos si pulsamos
	ld	b,150
pausa3:
	halt
	djnz	pausa3

; Esto lo realizamos para que no se vea nada en la pantalla
; Mientras colocamos los CHR y los Colores en la VRAM 
	call	DISSCR			; 041h - BIOS - Disable screen

; Descomprimir los grficos banco 2 para el final del juego
	ld	hl,CHRs_FINAL1		; origen
	ld	de,bufferCHR		; destino
	call	unpack			; rutina descompresora pletter de rom a ram
; Descomprimir la pantalla 2 para el final del juego
	ld	hl,NAM_FINAL2		; origen
	ld	de,bufferNAM		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Colocar el buffer de CHRs de RAM en VRAM
	ld	de,CHRTBL+2048		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM

; Colocar el bufferNAM en VRAM
	call	bufNAMaVRAM		; Mini-Rutina que lleva bufferNAM a VRAM 24 lineas

; colocar el color para los CHRs del BANCO 0 en GRIS
	ld	hl,CLRTBL+2048		; CLRTBL en VRAM
	ld	bc,256*8		; n de bytes a rellenar 256 CHRs * 8 bytes
	ld	a,$E0			; a=E0 - Valor a rellenar color gris fondo negro
	call	FILVRM			; 056h - BIOS  Fill block of VRAM with data byte 

; Esto lo realizamos para que se muestre de nuevo la pantalla.
	call    ENASCR			; 044h - BIOS - Enable screen

; texto de la animacion 3
	ld	de,TXT_FINAL3		; direccion del texto a imprimir
	ld	hl,NAMTBL+(16*32)	; LOCATE 9,0 en la NAMBTL en VRAM
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR

; bucle para una pausa
	ld	b,150
pausa4:
	halt
	djnz	pausa4

; Descomprimir la pantalla 3 para el final del juego
	ld	hl,NAM_FINAL3		; origen
	ld	de,bufferNAM		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Colocar el bufferNAM en VRAM
	call	bufNAMaVRAM		; Mini-Rutina que lleva bufferNAM a VRAM 24 lineas

; texto de la animacion 4
	ld	de,TXT_FINAL4		; direccion del texto a imprimir
	ld	hl,NAMTBL+(17*32)	; LOCATE 9,0 en la NAMBTL en VRAM
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR

; bucle para una pausa
	ld	b,150
pausa5:
	halt
	djnz	pausa5

; Colocar el bufferNAM en VRAM
	call	bufNAMaVRAM		; Mini-Rutina que lleva bufferNAM a VRAM 24 lineas

; texto de la animacion 5
	ld	de,TXT_FINAL5		; direccion del texto a imprimir
	ld	hl,NAMTBL+(17*32)	; LOCATE 9,0 en la NAMBTL en VRAM
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR

; bucle para una pausa
	ld	b,150
pausa6:
	halt
	djnz	pausa6

; Colocar el buffer de CHRs de RAM en VRAM
	ld	de,CHRTBL		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM

; Descomprimir la pantalla 4 para el final del juego
	ld	hl,NAM_FINAL4		; origen
	ld	de,bufferNAM		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Colocar el bufferNAM en VRAM
	call	bufNAMaVRAM		; Mini-Rutina que lleva bufferNAM a VRAM 24 lineas

; texto de la animacion 6
	ld	de,TXT_FINAL6		; direccion del texto a imprimir
	ld	hl,NAMTBL+(17*32)	; LOCATE 9,0 en la NAMBTL en VRAM
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR

; Descomprimir la pantalla 5 para el final del juego
	ld	hl,NAM_FINAL5		; origen
	ld	de,bufferNAM+(12*32)	; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Colocar el bufferNAM en VRAM
	ld	hl,bufferNAM+(12*32)	; origen
	ld	de,NAMTBL+(12*32)	; destino
	ld	bc,4*32
	call	LDIRVM			; Mini-Rutina que lleva bufferNAM a VRAM 24 lineas

; Descomprimir la pantalla 6 para el final del juego
	ld	hl,NAM_FINAL6		; origen
	ld	de,bufferNAM+(12*32)	; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; bucle para una pausa
	ld	b,150
pausa7:
	halt
	djnz	pausa7

; Colocar el bufferNAM en VRAM
	call	bufNAMaVRAM		; Mini-Rutina que lleva bufferNAM a VRAM 24 lineas

; texto de la animacion 7
	ld	de,TXT_FINAL7		; direccion del texto a imprimir
	ld	hl,NAMTBL+(17*32)	; LOCATE 17,0 en la NAMBTL en VRAM
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR

; bucle para una pausa
	ld	b,150
pausa8:
	halt
	djnz	pausa8

	call	GFXmenus		; Colocar los graficos logos y letras de los menus

; vamos a borrar la pantalla NAMTBL en VRAM
	ld	hl,NAMTBL		; inicio
	ld	bc,24*32		; tamao 24 lineas x 32 CHR
	xor	a			; rellenar con 0
	call	FILVRM			; 056h - BIOS  Fill block of VRAM with data byte

; LOCATE 11,15: PRINT "FIN"
	ld	hl,TXT_FIN		; direccin donde tenemos  el texto
IF (IDIOMA==1)
	ld	de,NAMTBL+(11*32)+15	; LOCATE 11,15 en la NAMBTL en VRAM
	ld	bc,3			; Numero de CHR que tiene el texto
ELSE
	ld	de,NAMTBL+(11*32)+12	; LOCATE 11,12 en la NAMBTL en VRAM
	ld	bc,7			; Numero de CHR que tiene el texto
ENDIF
	call	LDIRVM			; 056h - BIOS  Copy block to VRAM, from memory

;--------------------------------------
; WYZ
	ld	a,$10
	call	@@START_FADE_OUT	; parar la musica de mas a menos
; WYZ
;--------------------------------------

; bucle para una pausa
	ld	b,255
pausa9:
	halt
	djnz	pausa9

	jp	INI_ROM			; lo mandamos al inicio de la ROM


;-----------------------------------------------------------
; Fichero con todos los textos del Final del juego con PLETTER
;-----------------------------------------------------------
TXTs_FINAL:
IF IDIOMA==1
	.incbin	"code_bin\txtFINALe.z80.plet5"
ELSE
	.incbin	"code_bin\txtFINALi.z80.plet5"
ENDIF
;-----------------------------------------------------------

;-----------------------------------------------------------
; BANCO 0 DE CHRs PARA LAS ANIMACIONES FINALES
CHRs_FINAL0:
	.incbin	"gfx_bin\final0.til.plet5"
;-----------------------------------------------------------
; BANCO 1 DE CHRs PARA LAS ANIMACIONES FINALES
CHRs_FINAL1:
	.incbin	"gfx_bin\final1.til.plet5"
;-----------------------------------------------------------

;-----------------------------------------------------------
; NAMTBL del pergamino comprimida con PLETTER
NAM_FINAL0:
	.incbin	"gfx_bin\final0.nam.plet5"
;-----------------------------------------------------------
; NAMTBL del raul leyendo comprimida con PLETTER
NAM_FINAL1:
	.incbin	"gfx_bin\final1.nam.plet5"
;-----------------------------------------------------------
; NAMTBL del mansion comprimida con PLETTER
NAM_FINAL2:
	.incbin	"gfx_bin\final2.nam.plet5"
;-----------------------------------------------------------
; NAMTBL del escudo comprimida con PLETTER
NAM_FINAL3:
	.incbin	"gfx_bin\final3.nam.plet5"
;-----------------------------------------------------------
; NAMTBL de la chimenea comprimida con PLETTER
NAM_FINAL4:
	.incbin	"gfx_bin\final4.nam.plet5"
;-----------------------------------------------------------

;-----------------------------------------------------------
; mini-NAMTBL de la chimenea comprimida con PLETTER
NAM_FINAL5:
	.incbin	"gfx_bin\chimenea1.z80.plet5"
;-----------------------------------------------------------
; mini-NAMTBL de la chimenea comprimida con PLETTER
NAM_FINAL6:
	.incbin	"gfx_bin\chimenea2.z80.plet5"
;-----------------------------------------------------------
